# 画面設計書 20-Multi Term Vectors

## 概要

本ドキュメントは、OpenSearchのMulti Term Vectors API（`_mtermvectors`）エンドポイントに関する画面設計書である。1回のリクエストで複数のドキュメントのterm vectors情報を一括取得するためのREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、複数のドキュメントのterm vectors情報を1回のリクエストで取得する機能を提供する。Term Vectors API（No.19）の一括版であり、個別にリクエストを繰り返す代わりに、1回のHTTPリクエストで複数ドキュメントのterm vectors情報を取得でき、ネットワークラウンドトリップを削減する。

**業務上の目的・背景**：複数のドキュメントのterm vectors情報を比較・分析する場合（例：類似ドキュメントの検出、クラスタリング分析、テキスト分類の特徴量抽出）、個別のTerm Vectors APIを繰り返すのは非効率である。Multi Term Vectors APIにより、1回のリクエストで複数ドキュメントのterm vectors情報を取得し、分析の効率化を実現する。

**画面へのアクセス方法**：HTTPクライアントから`GET /_mtermvectors`または`POST /_mtermvectors`、`GET /{index}/_mtermvectors`または`POST /{index}/_mtermvectors`エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. リクエストボディの`docs`配列または`ids`配列からドキュメント指定を解析する
2. テンプレートとなるTermVectorsRequestを構築し、URLパラメータからデフォルト設定を取得する
3. 各ドキュメントのterm vectorsを取得する
4. 結果を集約してレスポンスを構築する

**画面遷移**：Term Vectors（No.19）の一括版。検索（No.21）の結果に対する一括term vectors分析に使用できる。

**権限による表示制御**：対象インデックスに対するread権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | TermVectors API | 主機能 | 1リクエストで複数のtermvectorsを一括取得する処理 |

## 画面種別

API（複数ドキュメント語彙分析一括取得）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET/POST | `/_mtermvectors` | インデックス指定なし（ボディ内で個別指定） |
| GET/POST | `/{index}/_mtermvectors` | デフォルトインデックスを指定 |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| index | string | いいえ | デフォルトのインデックス名 |

### クエリパラメータ

| パラメータ | 型 | 必須 | デフォルト | 説明 |
|-----------|------|------|-----------|------|
| ids | list | いいえ | - | ドキュメントIDのカンマ区切りリスト |
| term_statistics | boolean | いいえ | false | 総用語頻度とドキュメント頻度を返すかどうか |
| field_statistics | boolean | いいえ | true | ドキュメント数、ドキュメント頻度の合計、総用語頻度の合計を返すかどうか |
| fields | list | いいえ | - | 返すフィールドのカンマ区切りリスト |
| offsets | boolean | いいえ | true | 用語のオフセットを返すかどうか |
| positions | boolean | いいえ | true | 用語の位置を返すかどうか |
| payloads | boolean | いいえ | true | 用語のペイロードを返すかどうか |
| preference | string | いいえ | random | 操作を実行するノードまたはシャードの指定 |
| routing | string | いいえ | - | 特定のルーティング値 |
| realtime | boolean | いいえ | true | リアルタイムモードで操作を実行するかどうか |
| version | number | いいえ | - | 明示的なバージョン番号 |
| version_type | enum | いいえ | - | バージョン種別 |

### リクエストボディ

| フィールド | 型 | 必須 | 説明 |
|-----------|------|------|------|
| docs | array | docs/idsいずれか | ドキュメント指定の配列 |
| docs[]._index | string | いいえ | ドキュメントのインデックス名 |
| docs[]._id | string | はい | ドキュメントID |
| docs[].fields | array | いいえ | 取得するフィールドのリスト |
| docs[].term_statistics | boolean | いいえ | 用語統計取得制御 |
| docs[].field_statistics | boolean | いいえ | フィールド統計取得制御 |
| docs[].offsets | boolean | いいえ | オフセット取得制御 |
| docs[].positions | boolean | いいえ | 位置取得制御 |
| docs[].payloads | boolean | いいえ | ペイロード取得制御 |
| ids | array | docs/idsいずれか | ドキュメントIDの配列（URLでインデックス指定時） |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|------|------|
| docs | array | 各ドキュメントのterm vectors結果の配列 |
| docs[]._index | string | インデックス名 |
| docs[]._id | string | ドキュメントID |
| docs[]._version | number | ドキュメントバージョン |
| docs[].found | boolean | ドキュメントが見つかったかどうか |
| docs[].took | number | 処理時間 |
| docs[].term_vectors | object | フィールドごとのterm vector情報 |

## イベント仕様

### 1-Multi Term Vectorsリクエスト実行

1. `RestMultiTermVectorsAction.prepareRequest()`がリクエストを解析する（行76-85）
2. テンプレートとなる`TermVectorsRequest`を構築し、URLパラメータ（index）を設定する（行78）
3. `RestTermVectorsAction.readURIParameters()`を呼び出し、テンプレートにデフォルトパラメータを設定する（行80）
4. `ids`パラメータからIDリストを解析する（行81）
5. リクエストボディが存在する場合、`MultiTermVectorsRequest.add(template, parser)`でdocs/idsをパースする（行82）
6. `NodeClient.multiTermVectors()`を呼び出して一括取得を実行する（行84）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Multi Term Vectorsリクエスト | Luceneインデックス | SELECT | 複数ドキュメントのterm vector情報を読み取る（更新なし） |

### テーブル別更新項目詳細

本APIは読み取り専用であり、データベース（Luceneインデックス）の更新は行わない。

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| 成功 | 全ドキュメントのterm vectors取得成功 | HTTPステータス200、docs配列に各結果 |
| 部分成功 | 一部ドキュメント未発見 | HTTPステータス200、該当docsのfound=false |
| エラー | インデックス未存在 | 該当docsにerror情報が含まれる |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定インデックスが存在しない場合 | 該当ドキュメントのみ失敗 |

## 備考

- URLパラメータで設定した値はテンプレートとしてデフォルト値になり、個々のdocs内の指定で上書き可能
- `RestTermVectorsAction.readURIParameters()`を再利用しており、Term Vectors APIと同じパラメータ処理ロジックを共有している（行80）
- `ids`パラメータはクエリパラメータとボディの両方で指定可能
- ボディが任意（required: false）であるため、idsクエリパラメータのみでも使用可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mtermvectors.json | `rest-api-spec/src/main/resources/rest-api-spec/api/mtermvectors.json` | API定義。idsパラメータの存在に注目 |
| 1-2 | MultiTermVectorsRequest.java | `server/src/main/java/org/opensearch/action/termvectors/MultiTermVectorsRequest.java` | リクエストデータ構造。add()メソッドのテンプレートパターン |
| 1-3 | MultiTermVectorsResponse.java | `server/src/main/java/org/opensearch/action/termvectors/MultiTermVectorsResponse.java` | レスポンスデータ構造 |

**読解のコツ**: MultiTermVectorsRequest.add(template, parser)メソッドが核心。テンプレートのTermVectorsRequestから各ドキュメントの設定を継承し、個別指定で上書きするパターンに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestMultiTermVectorsAction.java | `server/src/main/java/org/opensearch/rest/action/document/RestMultiTermVectorsAction.java` | RESTハンドラ |

**主要処理フロー**:
1. **行59-66**: routes()で4つのルートを定義（GET/POST x /_mtermvectors と /{index}/_mtermvectors）
2. **行76-85**: prepareRequest()でMultiTermVectorsRequestの構築
3. **行78**: テンプレートTermVectorsRequestの構築（URLのインデックスを設定）
4. **行80**: RestTermVectorsAction.readURIParameters()でテンプレートにパラメータ設定
5. **行81**: idsパラメータの解析
6. **行82**: withContentOrSourceParamParserOrNull()でボディパース
7. **行84**: NodeClient.multiTermVectors()の呼び出し

#### Step 3: テンプレートパターンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestTermVectorsAction.java | `server/src/main/java/org/opensearch/rest/action/document/RestTermVectorsAction.java` | readURIParameters()の共有ロジック |

### プログラム呼び出し階層図

```
RestMultiTermVectorsAction.prepareRequest()             [行76]
    |
    +-- TermVectorsRequest(index)                       [テンプレート構築, 行78]
    |
    +-- RestTermVectorsAction.readURIParameters()       [パラメータ設定, 行80]
    |
    +-- MultiTermVectorsRequest.ids()                   [ID設定, 行81]
    |
    +-- MultiTermVectorsRequest.add(template, parser)   [ボディパース, 行82]
    |
    +-- NodeClient.multiTermVectors()                   [行84]
            |
            +-- TransportMultiTermVectorsAction
                    +-- 各ドキュメントのterm vectors取得
```

### データフロー図

```
[入力]                           [処理]                              [出力]

HTTPリクエスト            RestMultiTermVectorsAction          MultiTermVectorsResponse
(POST /_mtermvectors)  テンプレート構築・パラメータ設定
   |                              |
   v                              v
リクエストボディ        TransportMultiTermVectorsAction         レスポンスJSON
{docs:[...]}            各ドキュメントのterm vectors取得        {docs:[...]}
or {ids:[...]}                    |
   |                              v
   v                    TermVectorsAction (個別実行)           各docのterm_vectors
テンプレートパラメータ    Luceneからterm vector読取             (found/term_vectors)
(fields, offsets等)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mtermvectors.json | `rest-api-spec/src/main/resources/rest-api-spec/api/mtermvectors.json` | API定義 | REST API仕様 |
| RestMultiTermVectorsAction.java | `server/src/main/java/org/opensearch/rest/action/document/RestMultiTermVectorsAction.java` | ソース | RESTハンドラ |
| RestTermVectorsAction.java | `server/src/main/java/org/opensearch/rest/action/document/RestTermVectorsAction.java` | ソース | readURIParameters()の共有 |
| MultiTermVectorsRequest.java | `server/src/main/java/org/opensearch/action/termvectors/MultiTermVectorsRequest.java` | ソース | リクエストデータ構造 |
| MultiTermVectorsResponse.java | `server/src/main/java/org/opensearch/action/termvectors/MultiTermVectorsResponse.java` | ソース | レスポンスデータ構造 |
| TransportMultiTermVectorsAction.java | `server/src/main/java/org/opensearch/action/termvectors/TransportMultiTermVectorsAction.java` | ソース | Transport層の実行処理 |
| TermVectorsRequest.java | `server/src/main/java/org/opensearch/action/termvectors/TermVectorsRequest.java` | ソース | テンプレートとして使用されるリクエスト |
